using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.Common;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/23/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

	public class FrmMedProfile : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;
		//
		private System.ComponentModel.IContainer components = null;
		private DataSet _dsReport;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.Panel pnlMedProfile;
		private System.Windows.Forms.Panel pnlPatientSearch;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnCancelPatient;
		private System.Windows.Forms.Button btnSearch;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.PrintDialog printDialog1;

		/// <summary>
		/// MedProfileReport object
		/// </summary>
        private controls.VbecsReportViewer rvMedProfile;

		private System.DateTime _currentDate;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmMedProfile()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.pnlPatientSearch.Visible = true;
			this.pnlMedProfile.Visible = false;
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		public FrmMedProfile(BOL.Patient patient) : this()
		{
			this.Patient = patient;
			this.pnlPatientSearch.Visible = false;
			this.pnlMedProfile.Visible = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmMedProfile));
            this.pnlMedProfile = new System.Windows.Forms.Panel();
            this.rvMedProfile = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.grpDateRange = new System.Windows.Forms.GroupBox();
            this.lblEndDate = new System.Windows.Forms.Label();
            this.lblStartDate = new System.Windows.Forms.Label();
            this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
            this.btnSearch = new System.Windows.Forms.Button();
            this.pnlPatientSearch = new System.Windows.Forms.Panel();
            this.btnCancelPatient = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlMedProfile.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.grpDateRange.SuspendLayout();
            this.pnlPatientSearch.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
            this.vbecsLogo1.TabIndex = 2;
            this.vbecsLogo1.Title = "Patient Medication Profile";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 3;
            // 
            // pnlMedProfile
            // 
            this.pnlMedProfile.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlMedProfile.Controls.Add(this.rvMedProfile);
            this.pnlMedProfile.Controls.Add(this.btnCancel);
            this.pnlMedProfile.Controls.Add(this.btnPrint);
            this.pnlMedProfile.Controls.Add(this.grpImage);
            this.pnlMedProfile.Controls.Add(this.grpDateRange);
            this.pnlMedProfile.Location = new System.Drawing.Point(0, 32);
            this.pnlMedProfile.Name = "pnlMedProfile";
            this.pnlMedProfile.Size = new System.Drawing.Size(740, 492);
            this.pnlMedProfile.TabIndex = 1;
            // 
            // rvMedProfile
            // 
            this.rvMedProfile.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvMedProfile.Location = new System.Drawing.Point(60, 55);
            this.rvMedProfile.Name = "rvMedProfile";
            this.rvMedProfile.Size = new System.Drawing.Size(677, 405);
            this.rvMedProfile.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnCancel.Location = new System.Drawing.Point(664, 464);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.Enabled = false;
            this.btnPrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(584, 464);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 2;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 0);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 464);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // grpDateRange
            // 
            this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDateRange.Controls.Add(this.lblEndDate);
            this.grpDateRange.Controls.Add(this.lblStartDate);
            this.grpDateRange.Controls.Add(this.dtpStartDate);
            this.grpDateRange.Controls.Add(this.btnSearch);
            this.grpDateRange.Location = new System.Drawing.Point(60, 0);
            this.grpDateRange.Name = "grpDateRange";
            this.grpDateRange.Size = new System.Drawing.Size(678, 48);
            this.grpDateRange.TabIndex = 0;
            this.grpDateRange.TabStop = false;
            this.grpDateRange.Text = "Select Date Range for Search";
            // 
            // lblEndDate
            // 
            this.lblEndDate.Location = new System.Drawing.Point(172, 20);
            this.lblEndDate.Name = "lblEndDate";
            this.lblEndDate.Size = new System.Drawing.Size(156, 20);
            this.lblEndDate.TabIndex = 2;
            this.lblEndDate.Text = " Through Date  ";
            this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblStartDate
            // 
            this.lblStartDate.Location = new System.Drawing.Point(8, 20);
            this.lblStartDate.Name = "lblStartDate";
            this.lblStartDate.Size = new System.Drawing.Size(60, 20);
            this.lblStartDate.TabIndex = 0;
            this.lblStartDate.Text = "Start Date*";
            this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpStartDate
            // 
            this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.dtpStartDate.CustomFormat = "";
            this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
            this.dtpStartDate.Name = "dtpStartDate";
            this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
            this.dtpStartDate.TabIndex = 1;
            this.dtpStartDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
            // 
            // btnSearch
            // 
            this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
            this.btnSearch.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnSearch.Location = new System.Drawing.Point(340, 18);
            this.btnSearch.Name = "btnSearch";
            this.btnSearch.Size = new System.Drawing.Size(75, 23);
            this.btnSearch.TabIndex = 4;
            this.btnSearch.Text = "Search";
            this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // pnlPatientSearch
            // 
            this.pnlPatientSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPatientSearch.Controls.Add(this.btnCancelPatient);
            this.pnlPatientSearch.Controls.Add(this.btnOK);
            this.pnlPatientSearch.Controls.Add(this.patientSelectTool1);
            this.pnlPatientSearch.Location = new System.Drawing.Point(0, 32);
            this.pnlPatientSearch.Name = "pnlPatientSearch";
            this.pnlPatientSearch.Size = new System.Drawing.Size(740, 492);
            this.pnlPatientSearch.TabIndex = 0;
            // 
            // btnCancelPatient
            // 
            this.btnCancelPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelPatient.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancelPatient.Location = new System.Drawing.Point(664, 464);
            this.btnCancelPatient.Name = "btnCancelPatient";
            this.btnCancelPatient.Size = new System.Drawing.Size(75, 24);
            this.btnCancelPatient.TabIndex = 2;
            this.btnCancelPatient.Text = "&Cancel";
            this.btnCancelPatient.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(584, 464);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 24);
            this.btnOK.TabIndex = 1;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSelectTool1.Location = new System.Drawing.Point(4, 0);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.patientSelectTool1.Size = new System.Drawing.Size(736, 460);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // FrmMedProfile
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(742, 523);
            this.Controls.Add(this.pnlMedProfile);
            this.Controls.Add(this.pnlPatientSearch);
            this.hlphelpChm.SetHelpKeyword(this, "Medication_Profile.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(750, 550);
            this.Name = "FrmMedProfile";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Patient Medication Profile";
            this.Load += new System.EventHandler(this.FrmMedProfile_Load);
            this.Controls.SetChildIndex(this.pnlPatientSearch, 0);
            this.Controls.SetChildIndex(this.pnlMedProfile, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlMedProfile.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.grpDateRange.ResumeLayout(false);
            this.pnlPatientSearch.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{

			this.vbecsLogo1.Title = "Patient Medication Profile";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC046.FrmMedProfile());

			//set custom date and time format
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;

			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			
			this.dtpStartDate.Value = _currentDate.AddMonths(-6);
			this.dtpStartDate.MaxDate = _currentDate.Date;
			//
			this.lblEndDate.Text = " Through Date  " + Common.VBECSDateTime.FormatDateString(_currentDate.Date);
			//
			this.patientSelectTool1.EnabledMedicationButton = false;
            this.rvMedProfile.Visible = false;
            BOL.VbecsReport.SetUpReportButtons(this.rvMedProfile);
        }

		/// <summary>
		/// Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
			}
		}

		private void btnSearch_Click( object sender, System.EventArgs e )
		{
			if( dtpStartDate.Value > _currentDate.Date )
			{
				GuiMessenger.ShowMessageBox( Common.StrRes.ValidMsg.UC046.StartDateMustBePriorToEndDate() );
				return;
			}

			using( new WaitCursor() )
			{
				if( !VistALink.EnsureAvailability() )
					return;

				_dsReport = DAL.VAL.MedicationProfile.GetMedicationProfile( _patient.VistaPatientId, dtpStartDate.Value, _currentDate.Date );


				DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
				string ReportCriteria = "Start Date: " + Common.VBECSDateTime.FormatDateString(dtpStartDate.Value.Date)+" \nEndDate: "+Common.VBECSDateTime.FormatDateString(_currentDate.Date);
				DataSet dsFooter = BOL.VbecsReport.GetReportFooter(ReportCriteria);

                ReportDataSource reportSourcePatient = new ReportDataSource();
                if (_dsReport.Tables.Count > 0)
                {
                    reportSourcePatient.Name = "MedProfilePatientDataSet";
                    reportSourcePatient.Value = _dsReport.Tables[0];
                }

                ReportDataSource reportSourceOrder = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSourceOrder.Name = "MedProfileOrderDataSet";
                    reportSourceOrder.Value = _dsReport.Tables[1];
                }

                ReportDataSource reportSourceHeader = new ReportDataSource();
                if (dsHeader.Tables.Count > 0)
                {
                    reportSourceHeader.Name = "ReportHeaderDataSet";
                    reportSourceHeader.Value = dsHeader.Tables[0];
                }

                ReportDataSource reportSourceFooter = new ReportDataSource();
                if (dsFooter.Tables.Count > 0)
                {
                    reportSourceFooter.Name = "ReportFooterDataSet";
                    reportSourceFooter.Value = dsFooter.Tables[0];
                }

                Assembly assembly = Assembly.LoadFrom("Reports.dll");
                Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.MedicationProfile.MedProfileReport.rdlc");

                this.rvMedProfile.LocalReport.DataSources.Add(reportSourceHeader);
                this.rvMedProfile.LocalReport.DataSources.Add(reportSourceFooter);
                this.rvMedProfile.LocalReport.DataSources.Add(reportSourcePatient);
                this.rvMedProfile.LocalReport.DataSources.Add(reportSourceOrder);
                this.rvMedProfile.LocalReport.LoadReportDefinition(stream);
                this.rvMedProfile.Visible = true;
                this.rvMedProfile.RefreshReport();

				this.btnPrint.Enabled = true;
			}
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this._patient = null;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.btnOK.EnabledButton = false;
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this._patient = patientSelectTool1.SelectedPatient;
			this.patientSelectTool1.EnabledBloodAvailButton = true;
			this.patientSelectTool1.EnabledRecentOrdersButton = true;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = true;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = true;
			this.btnOK.EnabledButton = true;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.pnlMedProfile.Visible = true;
			this.pnlPatientSearch.Visible = false;
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvMedProfile.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

        private void FrmMedProfile_Load(object sender, EventArgs e)
        {

            this.rvMedProfile.RefreshReport();
        }
	}
}

